AutoDisableSteeringAssistLines = {}
AutoDisableSteeringAssistLines.IS_ACTIVE = true
AutoDisableSteeringAssistLines.TIMEOUT = 3000

function AutoDisableSteeringAssistLines.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AIAutomaticSteering, specializations)
end

function AutoDisableSteeringAssistLines.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", AutoDisableSteeringAssistLines)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdateTick", AutoDisableSteeringAssistLines)
end

function AutoDisableSteeringAssistLines:onLoad(savegame)
    local spec = self.spec_aiAutomaticSteering
	spec.autoDisableLineTimer = 0
	spec.autoDisableLineState = false
end

function AutoDisableSteeringAssistLines:onUpdateTick(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
   if self.isClient then
		local spec = self.spec_aiAutomaticSteering
		if AutoDisableSteeringAssistLines.IS_ACTIVE then
			if self:getAIAutomaticSteeringState() == AIAutomaticSteering.STATE.ACTIVE and (spec.lastDistanceToEnd > AIAutomaticSteering.LINE_END_SOUND_DISTANCE or spec.lastDistanceToEnd == 0) then
				if spec.autoDisableLineTimer < AutoDisableSteeringAssistLines.TIMEOUT then
					spec.autoDisableLineTimer = spec.autoDisableLineTimer + dt
				elseif not spec.autoDisableLineState then
					spec.autoDisableLineState = true
				end
			elseif spec.autoDisableLineTimer > 0 or spec.autoDisableLineState then
				spec.autoDisableLineTimer = 0
				if spec.autoDisableLineState then
					spec.autoDisableLineState = false
				end
			end
		elseif spec.autoDisableLineState then
			spec.autoDisableLineState = false
		end
   end
end

FieldCourseVisual.update = Utils.overwrittenFunction(FieldCourseVisual.update, function(self, oldFunc, ...)
	if self.vehicle.spec_aiAutomaticSteering.autoDisableLineState then
		setVisibility(self.linkNode, false)
	else
		oldFunc(self, ...)
	end
end)
