
carwash = {};

local carwash_mt = Class(carwash);

function carwash.onCreate(id)
      g_currentMission:addUpdateable(carwash:new(id));
end

function carwash:new(id, customMt)


    local instance = {};
    if customMt ~= nil then
        setmetatable(instance, customMt);
    else
        setmetatable(instance, carwash_mt);
    end;
    instance.triggerId = id;

	instance.isEnabled = true;
	addTrigger(instance.triggerId, "carwashCallback", instance);
	
	instance.washPerSecond = Utils.getNoNil(getUserAttribute(id, "washPerSecond"),0.5);

	instance.washEffect = getChild(id,"Wascheffekt", 0);


	instance.animIsEnabled = false;
	instance.activated = false;

	instance.vehicleInTrigger = {};    

    return instance;
end

function carwash:delete()
	self.vehicleInTrigger = {};
	removeTrigger(self.triggerId);
end;

function carwash:update(dt)
	if table.getn(self.vehicleInTrigger) > 0 then

		local overallDirt = 0

		if self.activated then
			self.animIsEnabled = true
			setTranslation(self.washEffect, 0, 0, 0)
		end;

		for _,vehicle in pairs(self.vehicleInTrigger) do
			local vehicle = g_currentMission.nodeToObject[vehicle];
			self.foundVehicle = vehicle
			self.farmId = self.foundVehicle:getOwnerFarmId()
			if carwash:getDirtPercForObject(vehicle) > 0 then
				self.countXYZ = self.countXYZ + (self.washPerSecond/2);
				self.foundVehicle:addDirtAmount(-self.washPerSecond * dt / self.foundVehicle:getWashDuration())
				local newDirtPercentage = carwash:getDirtPercForObject(vehicle);

				overallDirt = overallDirt + newDirtPercentage;
				self.activated = true;
			end
		end;

		if overallDirt <= 0 and self:allVehiclesCleaned() then
			setTranslation(self.washEffect, 0, -100, 0)
			g_currentMission:showBlinkingWarning(g_i18n:getText("XYZCLEAN") , 300)


		end
	else
		self.countXYZ = 0
		if self.animIsEnabled then

			self.animIsEnabled = false;	
			self.activated = false;
			setTranslation(self.washEffect, 0, -100, 0)

		end
	end
end

function carwash:allVehiclesCleaned()
    for _, vehicleId in pairs(self.vehicleInTrigger) do
        local vehicle = g_currentMission.nodeToObject[vehicleId];
        if self:getDirtPercForObject(vehicle) > 0 then
            return false
        end
    end

    return true
end

function carwash:carwashCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
    local vehicle = g_currentMission:getNodeObject(otherId);
    if vehicle ~= nil then
        if onEnter and self:getDirtPercForObject(vehicle) > 0.10 then
            table.insert(self.vehicleInTrigger,otherId);
        end;
        if onLeave then
            for i=0, table.getn(self.vehicleInTrigger) do
                if self.vehicleInTrigger[i] ~= nil and self.vehicleInTrigger[i] == otherId then
                    table.remove(self.vehicleInTrigger, i);

                    local money = 5;
                    if  g_currentMission:getIsServer() then
                        g_currentMission:addMoney(-money, self.farmId, MoneyType.OTHER, true)
                    else
                    g_client:getServerConnection():sendEvent(SC_PayFineEvent.new(-money, self.farmId))
                    end
                end;
            end;
        end;
    end;
end;

function carwash:getDirtPercForObject(obj)
	if obj ~= nil then
		if obj.spec_washable ~= nil then
			local nodeCount = 0;
			local dirtAmount = 0;
			for _, node in pairs(obj.spec_washable.washableNodes) do
				dirtAmount = dirtAmount + node.dirtAmount;
				nodeCount = nodeCount + 1;
			end
			return carwash:calcPercentage(dirtAmount / nodeCount, 1);
		else
			return nil;
		end
	else
		return nil;
	end
end

function carwash:calcPercentage(curVal, maxVal)
	local per = curVal / maxVal * 100;
	return (math.floor(per * 10)/10);
end

g_onCreateUtil.addOnCreateFunction("carwash", carwash.onCreate);
